/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.index.CSSIndexQueryHelper;
import com.aptana.css.core.model.ElementElement;
import com.aptana.css.core.model.ICSSMetadataElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.css.core.model.ValueElement;
import com.aptana.css.core.parsing.CSSTokenType;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalComparator;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.CSSContextInformationValidator;
import com.aptana.editor.css.contentassist.LocationType;
import com.aptana.editor.css.internal.text.CSSModelFormatter;
import com.aptana.editor.css.parsing.CSSTokenScanner;
import com.aptana.editor.css.parsing.lexer.CSSLexemeProvider;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final Image ELEMENT_ICON = CSSPlugin.getImage("/icons/element.png");
    private static final Image PROPERTY_ICON = CSSPlugin.getImage("/icons/property.png");
    private static final Set<String> COLOR_PROPERTY_NAMES = CollectionsUtil.newSet((Object[])new String[]{"background", "border-bottom", "border-left", "border-right", "border-top", "border", "color", "background-color", "border-color", "border-top-color", "border-right-color", "border-bottom-color", "border-left-color", "outline-color"});
    private IContextInformationValidator _validator;
    private CSSIndexQueryHelper _queryHelper = new CSSIndexQueryHelper();
    private Lexeme<CSSTokenType> _currentLexeme;
    private IRange _replaceRange;
    private IRange _activeRange;

    public CSSContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    public CSSContentAssistProcessor(AbstractThemeableEditor editor, IRange activeRange) {
        this(editor);
        this._activeRange = activeRange;
    }

    protected void addAllElementProposals(List<ICompletionProposal> proposals, int offset) {
        List elements = this._queryHelper.getElements();
        if (elements != null) {
            for (ElementElement element : elements) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation((ICSSMetadataElement)element);
                List userAgentIdList = element.getUserAgentNames();
                String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                this.addProposal(proposals, element.getName(), ELEMENT_ICON, description, userAgentIds, offset);
            }
        }
    }

    protected void addAllPropertyProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        List properties = this._queryHelper.getProperties();
        if (properties != null) {
            String postfix = ": ";
            if (this._currentLexeme != null) {
                int index = lexemeProvider.getLexemeCeilingIndex(offset);
                Lexeme nextLexeme = lexemeProvider.getLexeme(index + 1);
                if (nextLexeme != null && nextLexeme.getType() == CSSTokenType.COLON) {
                    postfix = "";
                }
                switch ((CSSTokenType)this._currentLexeme.getType()) {
                    case COLON: {
                        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                        this._replaceRange = this._currentLexeme;
                        postfix = "";
                        break;
                    }
                    case LCURLY: 
                    case RCURLY: 
                    case SEMICOLON: {
                        this._currentLexeme = null;
                        this._replaceRange = null;
                        break;
                    }
                    default: {
                        if (this._currentLexeme.contains(offset) || this._currentLexeme.getEndingOffset() == offset - 1) break;
                        this._currentLexeme = null;
                        this._replaceRange = null;
                    }
                }
            }
            for (PropertyElement property : properties) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation((ICSSMetadataElement)property);
                List userAgentIdList = property.getUserAgentNames();
                String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                this.addProposal(proposals, property.getName(), String.valueOf(property.getName()) + postfix, PROPERTY_ICON, description, userAgentIds, offset);
            }
        }
    }

    protected void addClasses(List<ICompletionProposal> proposals, int offset) {
        Map classes = this._queryHelper.getClasses(this.getIndex());
        if (classes != null) {
            UserAgentManager manager = UserAgentManager.getInstance();
            String[] userAgentIds = manager.getActiveUserAgentIDs(this.getProject());
            for (Map.Entry entry : classes.entrySet()) {
                String name = "." + (String)entry.getKey();
                String location = CSSModelFormatter.getDocumentDisplayName((String)entry.getValue());
                this.addProposal(proposals, name, ELEMENT_ICON, null, userAgentIds, location, offset);
            }
        }
    }

    protected void addIDs(List<ICompletionProposal> proposals, int offset) {
        Map ids = this._queryHelper.getIDs(this.getIndex());
        if (ids != null) {
            UserAgentManager manager = UserAgentManager.getInstance();
            String[] userAgentIds = manager.getActiveUserAgentIDs(this.getProject());
            for (Map.Entry entry : ids.entrySet()) {
                String name = "#" + (String)entry.getKey();
                String location = CSSModelFormatter.getDocumentDisplayName((String)entry.getValue());
                this.addProposal(proposals, name, ELEMENT_ICON, null, userAgentIds, location, offset);
            }
        }
    }

    private void addInsideRuleProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        LocationType location = this.getInsideLocationType(lexemeProvider, offset);
        if (location == LocationType.ERROR && lexemeProvider.size() == 0) {
            location = LocationType.INSIDE_PROPERTY;
        }
        switch (location) {
            case INSIDE_PROPERTY: {
                this.addAllPropertyProposals(proposals, lexemeProvider, offset);
                break;
            }
            case INSIDE_VALUE: {
                this.addPropertyValues(proposals, lexemeProvider, offset);
                break;
            }
        }
    }

    private void addOutsideRuleProposals(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        if (this._currentLexeme != null) {
            switch ((CSSTokenType)this._currentLexeme.getType()) {
                case COMMA: {
                    this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset);
                    this._replaceRange = this._currentLexeme;
                    break;
                }
                case COLON: {
                    this._replaceRange = null;
                    break;
                }
                case GREATER: {
                    this._replaceRange = null;
                    break;
                }
                case LCURLY: 
                case RCURLY: {
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    ++offset;
                    break;
                }
                case IDENTIFIER: 
                case ELEMENT: {
                    if (offset != this._currentLexeme.getStartingOffset()) break;
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case RPAREN: {
                    this._replaceRange = null;
                    if (offset > this._currentLexeme.getStartingOffset()) break;
                    this._currentLexeme = lexemeProvider.getLexemeFromOffset(this._currentLexeme.getStartingOffset() - 1);
                    if (this._currentLexeme == null || this._currentLexeme.getType() != CSSTokenType.IDENTIFIER) break;
                    this._replaceRange = this._currentLexeme;
                    break;
                }
            }
        }
        if (this._currentLexeme != null) {
            Lexeme previous;
            Lexeme switchLexeme = this._currentLexeme;
            if (switchLexeme.getType() == CSSTokenType.IDENTIFIER && (previous = lexemeProvider.getLexemeFromOffset(this._currentLexeme.getStartingOffset() - 1)) != null && (previous.getType() == CSSTokenType.COLON || previous.getType() == CSSTokenType.LPAREN)) {
                switchLexeme = previous;
            }
            switch ((CSSTokenType)switchLexeme.getType()) {
                case CLASS: {
                    this.addClasses(proposals, offset);
                    break;
                }
                case ID: {
                    this.addIDs(proposals, offset);
                    break;
                }
                case COLON: {
                    previous = lexemeProvider.getLexemeFromOffset(switchLexeme.getStartingOffset() - 1);
                    if (previous != null && previous.getType() == CSSTokenType.COLON) {
                        this.addPseudoElementProposals(proposals, offset);
                        break;
                    }
                    if (this._currentLexeme.getEndingOffset() < offset) {
                        this.addPseudoClassProposals(proposals, offset);
                        break;
                    }
                    this.addAllElementProposals(proposals, offset);
                    break;
                }
                case LPAREN: {
                    String pseudoClassName = null;
                    Lexeme lex = lexemeProvider.getLexemeFromOffset(switchLexeme.getStartingOffset() - 1);
                    if (lex.getType() == CSSTokenType.IDENTIFIER) {
                        pseudoClassName = lex.getText();
                    }
                    this.addPseudoClassArguments(pseudoClassName, proposals, offset);
                    break;
                }
                case RPAREN: {
                    break;
                }
                default: {
                    this.addAllElementProposals(proposals, offset);
                    break;
                }
            }
        } else {
            this.addAllElementProposals(proposals, offset);
        }
    }

    private void addPropertyValues(List<ICompletionProposal> proposals, ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        String propertyName = this.getPropertyName(lexemeProvider, offset);
        if (!StringUtil.isEmpty((String)propertyName)) {
            Set colors;
            String[] userAgentIds;
            this.setPropertyValueRange(lexemeProvider, offset);
            PropertyElement property = this._queryHelper.getProperty(propertyName);
            if (property != null) {
                List userAgentIdList = property.getUserAgentNames();
                userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                for (ValueElement value : property.getValues()) {
                    this.addProposal(proposals, value.getName(), PROPERTY_ICON, value.getDescription(), userAgentIds, offset);
                }
            }
            if (this.supportsColorValues(property) && (colors = this._queryHelper.getColors(this.getIndex())) != null && !colors.isEmpty()) {
                userAgentIds = this.getActiveUserAgentIds();
                for (String color : colors) {
                    ImageRegistry reg = CSSPlugin.getDefault().getImageRegistry();
                    Image img = reg.get(color);
                    if (img == null) {
                        String s = color.substring(1, 3);
                        int r = Integer.parseInt(s, 16);
                        s = color.substring(3, 5);
                        int g = Integer.parseInt(s, 16);
                        s = color.substring(5, 7);
                        int b = Integer.parseInt(s, 16);
                        RGB rgb = new RGB(r, g, b);
                        PaletteData pd = new PaletteData(new RGB[]{rgb});
                        ImageData data = new ImageData(16, 16, 1, pd);
                        img = new Image((Device)Display.getCurrent(), data);
                        reg.put(color, img);
                    }
                    this.addProposal(proposals, color, img, null, userAgentIds, offset);
                }
            }
        }
    }

    protected void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, String[] userAgentIds, int offset) {
        this.addProposal(proposals, name, image, description, userAgentIds, "CSS Core", offset);
    }

    protected void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        this.addProposal(proposals, name, name, image, description, userAgentIds, fileLocation, offset);
    }

    protected void addProposal(List<ICompletionProposal> proposals, String displayName, String name, Image image, String description, String[] userAgentIds, int offset) {
        this.addProposal(proposals, displayName, name, image, description, userAgentIds, "CSS Core", offset);
    }

    protected void addProposal(List<ICompletionProposal> proposals, String displayName, String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        if (this.isActiveByUserAgent(userAgentIds)) {
            CommonCompletionProposal proposal = this.createProposal(displayName, name, image, description, userAgentIds, fileLocation, offset);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    protected void addPseudoClassArguments(String pseudoClassName, List<ICompletionProposal> proposals, int offset) {
        if (pseudoClassName == null) {
            return;
        }
        List classes = this._queryHelper.getPseudoClasses();
        if (classes != null) {
            for (PseudoClassElement pseudoClass : classes) {
                if (!pseudoClass.getName().equals(pseudoClassName)) continue;
                List values = pseudoClass.getValues();
                if (values == null) break;
                for (ValueElement value : values) {
                    List userAgentIdList = pseudoClass.getUserAgentNames();
                    String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                    this.addProposal(proposals, value.getName(), ELEMENT_ICON, value.getDescription(), userAgentIds, offset);
                }
            }
        }
    }

    protected void addPseudoClassProposals(List<ICompletionProposal> proposals, int offset) {
        List elements;
        List classes = this._queryHelper.getPseudoClasses();
        if (classes != null) {
            for (PseudoClassElement pseudoClass : classes) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation((ICSSMetadataElement)pseudoClass);
                List userAgentIdList = pseudoClass.getUserAgentNames();
                String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                this.addProposal(proposals, pseudoClass.getName(), ELEMENT_ICON, description, userAgentIds, offset);
            }
        }
        if ((elements = this._queryHelper.getPseudoElements()) != null) {
            for (PseudoElementElement pseudoElement : elements) {
                if (!pseudoElement.allowPseudoClassSyntax()) continue;
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation((ICSSMetadataElement)pseudoElement);
                List userAgentIdList = pseudoElement.getUserAgentNames();
                String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                this.addProposal(proposals, pseudoElement.getName(), ELEMENT_ICON, description, userAgentIds, offset);
            }
        }
    }

    protected void addPseudoElementProposals(List<ICompletionProposal> proposals, int offset) {
        List elements = this._queryHelper.getPseudoElements();
        if (elements != null) {
            for (PseudoElementElement pseudoElement : elements) {
                String description = CSSModelFormatter.ADDITIONAL_INFO.getDocumentation((ICSSMetadataElement)pseudoElement);
                List userAgentIdList = pseudoElement.getUserAgentNames();
                String[] userAgentIds = userAgentIdList.toArray(new String[userAgentIdList.size()]);
                this.addProposal(proposals, pseudoElement.getName(), ELEMENT_ICON, description, userAgentIds, offset);
            }
        }
    }

    ILexemeProvider<CSSTokenType> createLexemeProvider(IDocument document, int offset) {
        if (this._activeRange != null) {
            return new CSSLexemeProvider(document, this._activeRange, (ITokenScanner)new CSSTokenScanner());
        }
        IRange range = this.getLexemeRange(document, offset);
        return new CSSLexemeProvider(document, range, (ITokenScanner)new CSSTokenScanner());
    }

    protected CommonCompletionProposal createProposal(String displayName, String name, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        int length = name.length();
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgentIds);
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        IDocument document = viewer.getDocument();
        ILexemeProvider<CSSTokenType> lexemeProvider = this.createLexemeProvider(document, offset);
        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (this._currentLexeme == null) {
            this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
        }
        this._replaceRange = this._currentLexeme;
        LocationType location = this._activeRange == null ? this.getCoarseLocationType(lexemeProvider, offset) : LocationType.INSIDE_RULE;
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        switch (location) {
            case OUTSIDE_RULE: {
                this.addOutsideRuleProposals(result, lexemeProvider, offset);
                break;
            }
            case INSIDE_RULE: {
                this.addInsideRuleProposals(result, lexemeProvider, offset);
                break;
            }
            case INSIDE_ARG: {
                break;
            }
        }
        Collections.sort(result, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
            }
        });
        ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
        if (this._currentLexeme != null) {
            this.setSelectedProposal(this._currentLexeme.getText(), proposals);
        }
        return proposals;
    }

    LocationType getCoarseLocationType(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        LocationType result = LocationType.ERROR;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        block15: while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            switch ((CSSTokenType)lexeme.getType()) {
                case LCURLY: {
                    if (lexeme.getEndingOffset() < offset) {
                        result = LocationType.INSIDE_RULE;
                        this._currentLexeme = null;
                        this._replaceRange = null;
                        break block15;
                    }
                    result = LocationType.OUTSIDE_RULE;
                    this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                    this._replaceRange = this._currentLexeme;
                    break block15;
                }
                case RCURLY: {
                    result = lexeme.getEndingOffset() < offset ? LocationType.OUTSIDE_RULE : LocationType.INSIDE_RULE;
                    break block15;
                }
                case COLON: {
                    Lexeme candidate;
                    int i = index - 1;
                    while (i >= 0) {
                        candidate = lexemeProvider.getLexeme(i);
                        switch ((CSSTokenType)candidate.getType()) {
                            case COLOR: 
                            case LCURLY: 
                            case SEMICOLON: {
                                result = LocationType.INSIDE_RULE;
                                break block15;
                            }
                            case RCURLY: 
                            case ID: 
                            case CLASS: {
                                result = LocationType.OUTSIDE_RULE;
                                break block15;
                            }
                            default: {
                                --i;
                            }
                        }
                    }
                    i = index + 1;
                    while (i < lexemeProvider.size()) {
                        candidate = lexemeProvider.getLexeme(i);
                        switch ((CSSTokenType)candidate.getType()) {
                            case COLOR: 
                            case SEMICOLON: {
                                result = LocationType.INSIDE_RULE;
                                break block15;
                            }
                            case LCURLY: 
                            case ID: 
                            case CLASS: {
                                result = LocationType.OUTSIDE_RULE;
                                break block15;
                            }
                            default: {
                                ++i;
                            }
                        }
                    }
                    result = LocationType.OUTSIDE_RULE;
                    break block15;
                }
                case PROPERTY: 
                case VALUE: {
                    result = LocationType.INSIDE_RULE;
                    break block15;
                }
                case IDENTIFIER: 
                case MINUS: {
                    if (lexeme.getText().charAt(0) == '-') {
                        result = LocationType.INSIDE_RULE;
                        break block15;
                    }
                }
                default: {
                    --index;
                }
            }
        }
        if (index < 0 && result == LocationType.ERROR) {
            result = LocationType.OUTSIDE_RULE;
        }
        return result;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this._validator == null) {
            this._validator = new CSSContextInformationValidator();
        }
        return this._validator;
    }

    private int getIndexOfPreviousColon(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        int result = -1;
        int i = index;
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == CSSTokenType.COLON) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    LocationType getInsideLocationType(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        LocationType location = LocationType.ERROR;
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index < 0) {
            int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
            Lexeme lexeme = lexemeProvider.getLexeme(candidateIndex);
            index = lexeme != null && lexeme.getEndingOffset() == offset - 1 ? candidateIndex : lexemeProvider.getLexemeCeilingIndex(offset);
        }
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            block0 : switch ((CSSTokenType)lexeme.getType()) {
                case LCURLY: {
                    location = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case RCURLY: {
                    if (index <= 0) break;
                    Lexeme previousLexeme = lexemeProvider.getLexeme(index - 1);
                    if (previousLexeme.getEndingOffset() == offset - 1) {
                        switch ((CSSTokenType)previousLexeme.getType()) {
                            case CLASS: {
                                return LocationType.ERROR;
                            }
                            case ID: {
                                location = LocationType.INSIDE_VALUE;
                                break block0;
                            }
                            case LCURLY: 
                            case SEMICOLON: {
                                location = LocationType.INSIDE_PROPERTY;
                                break block0;
                            }
                        }
                        break;
                    }
                    switch ((CSSTokenType)previousLexeme.getType()) {
                        case COLON: {
                            location = LocationType.INSIDE_VALUE;
                            break block0;
                        }
                    }
                    location = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case PROPERTY: 
                case IDENTIFIER: 
                case ELEMENT: {
                    boolean afterColon = false;
                    int i = index - 1;
                    block21: while (i >= 0) {
                        Lexeme candidate = lexemeProvider.getLexeme(i);
                        switch ((CSSTokenType)candidate.getType()) {
                            case COLON: {
                                afterColon = true;
                                break block21;
                            }
                            case LCURLY: 
                            case RCURLY: 
                            case SEMICOLON: {
                                break block21;
                            }
                            default: {
                                --i;
                                continue block21;
                            }
                        }
                    }
                    if (afterColon) break;
                    if (lexeme.contains(offset) || lexeme.getEndingOffset() == offset - 1) {
                        this._currentLexeme = lexeme;
                        this._replaceRange = this._currentLexeme;
                    } else {
                        this._currentLexeme = null;
                        this._replaceRange = null;
                    }
                    location = LocationType.INSIDE_PROPERTY;
                    break;
                }
                case SEMICOLON: {
                    location = lexeme.getEndingOffset() < offset ? LocationType.INSIDE_PROPERTY : LocationType.INSIDE_VALUE;
                    break;
                }
                case COLON: {
                    location = lexeme.getEndingOffset() < offset ? LocationType.INSIDE_VALUE : LocationType.INSIDE_PROPERTY;
                    break;
                }
                case FUNCTION: 
                case VALUE: {
                    location = LocationType.INSIDE_VALUE;
                }
            }
            if (location != LocationType.ERROR) {
                return location;
            }
            --index;
        }
        return location;
    }

    private int getLexemeAfterDelimiter(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index >= 0) {
            Lexeme currentLexeme = lexemeProvider.getLexeme(index);
            if (currentLexeme.getType() == CSSTokenType.SEMICOLON) {
                currentLexeme = lexemeProvider.getLexeme(--index);
            }
            int i = index;
            while (i >= 0) {
                Lexeme previousLexeme;
                Lexeme lexeme = previousLexeme = i > 0 ? lexemeProvider.getLexeme(i - 1) : null;
                if (this.isValueDelimiter((Lexeme<CSSTokenType>)currentLexeme) || !previousLexeme.isContiguousWith(currentLexeme)) {
                    index = i;
                    break;
                }
                currentLexeme = previousLexeme;
                index = i--;
            }
        }
        return index;
    }

    private Lexeme<CSSTokenType> getLexemeBeforeDelimiter(ILexemeProvider<CSSTokenType> lexemeProvider, int index) {
        Lexeme result = null;
        Lexeme startingLexeme = lexemeProvider.getLexeme(index);
        if (startingLexeme != null && !this.isValueDelimiter((Lexeme<CSSTokenType>)startingLexeme)) {
            Lexeme endingLexeme = startingLexeme;
            ++index;
            while (index < lexemeProvider.size()) {
                Lexeme candidateLexeme = lexemeProvider.getLexeme(index);
                if (this.isValueDelimiter((Lexeme<CSSTokenType>)candidateLexeme) || !endingLexeme.isContiguousWith(candidateLexeme)) break;
                endingLexeme = candidateLexeme;
                ++index;
            }
            if (index >= lexemeProvider.size()) {
                endingLexeme = lexemeProvider.getLexeme(lexemeProvider.size() - 1);
            }
            result = endingLexeme;
        }
        return result;
    }

    protected IRange getLexemeRange(IDocument document, int offset) {
        int startOffset = 0;
        try {
            int testOffset = document.get(0, offset).lastIndexOf(125, offset);
            startOffset = testOffset < 0 ? 0 : testOffset + 1;
        }
        catch (BadLocationException testOffset) {
            // empty catch block
        }
        int endOffset = offset;
        try {
            ITypedRegion region = document.getPartition(offset);
            endOffset = Math.max(startOffset, region.getOffset() + region.getLength() - 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new Range(startOffset, endOffset);
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.css";
    }

    private String getPropertyName(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        String result = null;
        int index = this.getIndexOfPreviousColon(lexemeProvider, offset);
        if (index > 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index - 1);
            result = lexeme.getText();
        }
        return result;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return Character.isWhitespace(c);
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        EnumSet<CSSTokenType[]> types = EnumSet.of(CSSTokenType.LCURLY, new CSSTokenType[]{CSSTokenType.COMMA, CSSTokenType.COLON, CSSTokenType.SEMICOLON, CSSTokenType.CLASS, CSSTokenType.ID});
        ILexemeProvider<CSSTokenType> lexemeProvider = this.createLexemeProvider(document, offset);
        if (offset > 0) {
            Lexeme lexeme = lexemeProvider.getFloorLexeme(offset - 1);
            return lexeme != null ? types.contains(lexeme.getType()) : false;
        }
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return 65 <= keyCode && keyCode <= 90 || 97 <= keyCode && keyCode <= 122 || c == '_' || c == '#' || c == '.' || c == '-';
    }

    private boolean isValueDelimiter(Lexeme<CSSTokenType> lexeme) {
        boolean result = false;
        switch ((CSSTokenType)lexeme.getType()) {
            case LCURLY: 
            case RCURLY: 
            case COLON: 
            case SEMICOLON: 
            case COMMA: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void setActiveRange(IRange activeRange) {
        this._activeRange = activeRange;
    }

    private void setPropertyValueRange(ILexemeProvider<CSSTokenType> lexemeProvider, int offset) {
        Lexeme<CSSTokenType> endingLexeme;
        int index = this.getLexemeAfterDelimiter(lexemeProvider, offset);
        Lexeme<CSSTokenType> lexeme = endingLexeme = index >= 0 ? this.getLexemeBeforeDelimiter(lexemeProvider, index) : null;
        if (endingLexeme != null) {
            Lexeme startingLexeme = lexemeProvider.getLexeme(index);
            this._replaceRange = new Range(startingLexeme.getStartingOffset(), endingLexeme.getEndingOffset());
        } else if (this._currentLexeme != null && (this._currentLexeme.contains(offset) || this._currentLexeme.getEndingOffset() == offset - 1)) {
            switch ((CSSTokenType)this._currentLexeme.getType()) {
                case COLON: {
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case LCURLY: {
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case RCURLY: {
                    Lexeme candidate = lexemeProvider.getLexemeFromOffset(offset - 1);
                    if (candidate != null && !this.isValueDelimiter((Lexeme<CSSTokenType>)candidate)) {
                        this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                        this._replaceRange = this._currentLexeme;
                        break;
                    }
                    this._currentLexeme = null;
                    this._replaceRange = null;
                    break;
                }
                case SEMICOLON: {
                    this._currentLexeme = lexemeProvider.getLexemeFromOffset(offset - 1);
                    this._replaceRange = this._currentLexeme;
                    break;
                }
                default: {
                    this._replaceRange = this._currentLexeme;
                    break;
                }
            }
        } else {
            this._currentLexeme = null;
            this._replaceRange = null;
        }
    }

    protected void sortProposals(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, CompletionProposalComparator.descending((Comparator)CompletionProposalComparator.getComparator((CompletionProposalComparator[])new CompletionProposalComparator[]{CompletionProposalComparator.RelevanceSort, CompletionProposalComparator.NameSort})));
    }

    private boolean supportsColorValues(PropertyElement property) {
        if (property != null) {
            String propertyName = property.getName();
            return COLOR_PROPERTY_NAMES.contains(propertyName);
        }
        return false;
    }
}

